              
/*****************************************************************************
*                           Freescale Semiconductor                          *
*                   Brazilian Semiconductor Tecnology Center                 *
*                                                                            *
*  Project    : MC56F8006 Modular Pixel Matrix                               *
*  Version    : 0.1                                                          *
*  Date       : 27/Apr/2009                                                  *
*  Engineers  : Alexandre Dias, Bruno Bastos                                 *
*               Humberto Carvalho, Leonardo Mangiapelo                       *
*               Renato Frias                                                 *
*                                                                            *
* -------------------------------------------------------------------------- *
* THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR        *
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES  *
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.    *
* IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT,  *
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES         *
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR         *
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)         *
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,        * 
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING      *
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF             *
* THE POSSIBILITY OF SUCH DAMAGE.                                            *
* -------------------------------------------------------------------------- *
*  Description:                                                              *
* This software complements AN3815 - Implementing a Modular High Brightness  *
* RGB LED Network. The aim of the code is to proof the concept described on  *
* the application note document. It also serves as a starting point for      * 
* applications with MC56F8006 and some of its peripherals                    *
* -------------------------------------------------------------------------- *
*                                                                            *
*  File: iic.h	                                                             *
*                                                                            *
*    Header file for iic.c													 * 
*                                                                            *
******************************************************************************/

/************************* Project Include Files *****************************/

#ifndef _IIC_H
#define _IIC_H

#include "cpu.h"
#include "mc56f8006.h"

/********************************* Defines ***********************************/

/* I2C bus clock */
#define I2C_CLK  32000000ul // bus clock frequency in Hz


/* buffer size */
#define I2C_RX_BUF_SIZE		16
#define I2C_TX_BUF_SIZE		16

/* read/write operation code */
#define IIC_RW_READ		1
#define IIC_RW_WRITE	0
#define SLAVE_7BIT_ADDR_1    		1
#define SLAVE_7BIT_ADDR_2    
#define SLAVE_7BIT_ADDR_3  
#define SLAVE_7BIT_ADDR_4
#define SLAVE_10BIT_ADDR_1   		0x040
#define SLAVE_10BIT_ADDR_2   		0x25A
#define SLAVE_10BIT_ADDR_3
#define SLAVE_10BIT_ADDR_4
#define GENERAL_CALL_ADDR    		0x00
#define PRE_10_BIT_ADDR      		0xF0

/* I2C utility macros */
#define IIC_START()                 I2C_CR1 |= I2C_CR1_MST
#define IIC_STOP()                  I2C_CR1 &= ~I2C_CR1_MST
#define IIC_REPEAT_START()          I2C_CR1 |= I2C_CR1_RSTA 
#define CLEAR_IIC_INT()             I2C_SR  |= I2C_SR_IICIF
#define ENABLE_GENERAL_CALL()       I2C_CR2 |= I2C_CR2_GCAEN 
#define DISABLE_GENERAL_CALL()      I2C_CR2 &= ~I2C_CR2_GCAEN
#define SET_7BIT_MODE()             I2C_CR2 &= ~I2C_CR2_ADEXT
#define SET_10BIT_MODE()            I2C_CR2 |= ~I2C_CR2_ADEXT
#define ENABLE_IIC()                I2C_CR1 |= I2C_CR1_IICEN
#define DISABLE_IIC()               I2C_CR1 &= ~I2C_CR1_IICEN
#define ENABLE_IIC_INTERRUPT()      I2C_CR1 |= I2C_CR1_IICIE
#define DISABLE_IIC_INTERRUPT()     I2C_CR1 &= ~I2C_CR1_IICIE
#define SET_TRANSMIT_MODE()         I2C_CR1 |= I2C_CR1_TX
#define SET_RECEIVE_MODE()          I2C_CR1 &= ~I2C_CR1_TX
#define ENABLE_TRANSMIT_ACK()       I2C_CR1 |= I2C_CR1_TXAK
#define DISABLE_TRANSMIT_ACK()      I2C_CR1 &= ~I2C_CR1_TXAK
#define SET_BAUDRATE(br)             I2C_FREQDIV = br
#define SET_SLAVE_7BIT_ADDR(addr)    I2C_ADDR = (addr << 1)
#define SET_SLAVE_10BIT_ADDR(addr)   I2C_ADDR = ((addr << 1) & 0xFE); \
                                     I2C_CR2 = (I2C_CR2 & 0xFFF8) | ((addr >> 7) & 0x7)

/****************************** Prototypes ***********************************/

uint8_t IIC_set_bps(uint32_t bps);
void IIC_init_drv( int8_t* txBuf, int16_t txSize, int8_t* rxBuf, int16_t rxSize);
void IIC_SMBusIsrCallback (void);
void IIC_IsrCallback (void);
bool IIC_is_read_done(void);
bool IIC_is_write_done(void);
void IIC_set_RW_flag(bool read);
void IIC_set_FACK_flag(bool enable);
void srw (void);
void IIC_SMBusIsr(void);
extern void iic_init(void);

#endif